<?php defined( 'ABSPATH' ) || exit; ?>
<?php $customizer_link = admin_url('customize.php'); ?>
<?php $myadmin = site_url(); ?>
<div class="wrap">
    <?php require_once plugin_dir_path(dirname(__FILE__)) . 'partials/header.php'; ?>
    <section class="top">
        <div class="mycontainer">
            <h1><?php esc_html_e('Welcome to Solace', 'solace-extra'); ?></h1>
            <p class="desc"><?php esc_html_e('Solace is fast, fully customisable & beautiful WordPress theme suitable for blog, personal portfolio, business website and WooCommerce storefront. It is very lightweight and offers unparalleled speed.', 'solace-extra'); ?></p>
            <a href="<?php echo esc_url($myadmin . '/wp-admin/customize.php'); ?>" target="_blank">
                <?php esc_html_e('START CUSTOMISING', 'solace-extra'); ?>
            </a>
        </div>
    </section>
    <section class="box">
        <div class="mycontainer">
            <div class="row row1">
                <!-- left -->
                <div class="left">
                    <div class="box-colfull">
                        <div class="box1">
                            <span class="title"><?php esc_html_e('Starter Templates', 'solace-extra'); ?></span>
                            <span class="desc"><?php esc_html_e('Install a demo site in a few clicks.', 'solace-extra'); ?></span>
                            <a href="<?php echo esc_url($myadmin . '/wp-admin/admin.php?page=dashboard-video'); ?>"><?php esc_html_e('START NOW', 'solace-extra'); ?></a>
                        </div>
                        <div class="box2">
                        <?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage?><img src="<?php echo esc_url( SOLACE_EXTRA_ASSETS_URL . 'images/dashboard/start-template.png' ); ?>" />
                        </div>
                    </div>
                </div>
                <div class="right">
                    <!-- right -->
                    <div class="box-colfull">
                        <div class="box1">
                            <span class="title"><?php esc_html_e('Customize Solace', 'solace-extra'); ?></span>
                            <span class="desc"><?php esc_html_e('Cusotomize any part of your website.', 'solace-extra'); ?></span>
                            <a href="<?php echo esc_url($myadmin . '/wp-admin/customize.php'); ?>" target="_blank">
                                <?php esc_html_e('CUSTOMIZE', 'solace-extra'); ?>
                            </a>
                        </div>
                        <div class="box2">
                        <?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage?><img src="<?php echo esc_url( SOLACE_EXTRA_ASSETS_URL . 'images/dashboard/customizer.png' ); ?>" />
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row2">
                <div class="col1">
                    <svg width="53" height="52" viewBox="0 0 53 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M49.1689 22.765C48.967 17.0117 46.6371 11.6317 42.5461 7.54059C38.258 3.25174 32.5591 0.890564 26.5 0.890564C14.2622 0.890564 4.26286 10.6311 3.83183 22.765C1.96432 23.5949 0.657227 25.4641 0.657227 27.6366V33.6215C0.657227 36.5604 3.04807 38.9521 5.9878 38.9521C7.88993 38.9521 9.43685 37.4052 9.43685 35.503V25.7542C9.43685 23.9683 8.06712 22.512 6.3257 22.3389C6.96853 11.7676 15.7688 3.363 26.5 3.363C31.8998 3.363 36.9773 5.46787 40.7989 9.28943C44.3081 12.7986 46.3619 17.3726 46.6709 22.3398C44.9311 22.5145 43.5639 23.9699 43.5639 25.7542V35.5022C43.5639 37.303 44.955 38.7683 46.7171 38.9208V41.3841C46.7171 44.1582 44.4597 46.4147 41.6857 46.4147H37.9597C37.7767 45.8922 37.4899 45.4093 37.0877 45.0087C36.3831 44.3008 35.4436 43.911 34.4431 43.911H30.6026C30.0512 43.911 29.5221 44.028 29.0375 44.2538C27.7156 44.8612 26.8618 46.1947 26.8618 47.6509C26.8618 48.6514 27.2516 49.591 27.9579 50.294C28.6642 51.0019 29.6037 51.3917 30.6026 51.3917H34.4431C36.0353 51.3917 37.4388 50.3624 37.9622 48.8871H41.6857C45.8237 48.8871 49.1895 45.5213 49.1895 41.3841V38.4807C51.0455 37.6458 52.3427 35.7832 52.3427 33.6199V27.6349C52.3427 25.4641 51.0356 23.5949 49.1689 22.765ZM6.96359 25.7542V35.5022C6.96359 36.0404 6.52597 36.4788 5.98698 36.4788C4.41121 36.4788 3.12884 35.1964 3.12884 33.6207V27.6357C3.12884 26.0591 4.41121 24.7776 5.98698 24.7776C6.52597 24.7776 6.96359 25.216 6.96359 25.7542ZM35.6834 47.9163C35.5606 48.4981 35.0381 48.9209 34.4422 48.9209H30.6017C30.2638 48.9209 29.9465 48.7891 29.7042 48.5468C29.4652 48.3086 29.3334 47.9905 29.3334 47.6526C29.3334 47.1589 29.6226 46.7081 30.0759 46.4996C30.2375 46.4238 30.4146 46.385 30.6017 46.385H34.4422C34.7801 46.385 35.0974 46.5161 35.3389 46.7584C35.5779 46.9966 35.7098 47.3147 35.7098 47.6526C35.7106 47.7432 35.7007 47.8339 35.6834 47.9163ZM49.8702 33.6207C49.8702 35.1964 48.5879 36.4788 47.0121 36.4788C46.4739 36.4788 46.0355 36.0412 46.0355 35.5022V25.7542C46.0355 25.216 46.4731 24.7776 47.0121 24.7776C48.5879 24.7776 49.8702 26.06 49.8702 27.6357V33.6207Z" fill="#001344" />
                        <path d="M34.505 34.0468C37.3936 34.0468 39.7432 31.6963 39.7432 28.8085V18.135C39.7432 16.7389 39.1976 15.4236 38.207 14.4329C37.2164 13.4423 35.9019 12.8967 34.505 12.8967H18.4951C15.6065 12.8967 13.2568 15.2464 13.2568 18.135V28.8085C13.2568 31.6971 15.6065 34.0468 18.4951 34.0468H18.5932V36.8126C18.5932 37.8675 19.222 38.8037 20.1945 39.1985C20.5085 39.3246 20.8349 39.3872 21.1579 39.3872C21.8313 39.3872 22.4873 39.1202 22.9677 38.6233L27.569 34.0468H34.505ZM26.1885 31.9337L21.209 36.886C21.1868 36.909 21.1703 36.9263 21.1233 36.9057C21.0664 36.8827 21.0664 36.8456 21.0664 36.8126V32.8106C21.0664 32.1282 20.5134 31.5743 19.8302 31.5743H18.4959C16.9704 31.5743 15.7301 30.3332 15.7301 28.8085V18.135C15.7301 16.6095 16.9704 15.3692 18.4959 15.3692H34.5058C35.2426 15.3692 35.9357 15.6576 36.4598 16.1809C36.984 16.7051 37.2716 17.399 37.2716 18.135V28.8085C37.2716 30.334 36.0304 31.5743 34.5058 31.5743H27.0605C26.7333 31.5743 26.4201 31.7037 26.1885 31.9337Z" fill="#001344" />
                        <path d="M20.4942 21.8453C19.4888 21.8453 18.6704 22.6645 18.6704 23.6691C18.6704 24.6737 19.4896 25.4929 20.4942 25.4929C21.5005 25.4929 22.3197 24.6737 22.3197 23.6691C22.3197 22.6645 21.5013 21.8453 20.4942 21.8453Z" fill="#001344" />
                        <path d="M26.4991 21.8453C25.4937 21.8453 24.6753 22.6645 24.6753 23.6691C24.6753 24.6737 25.4945 25.4929 26.4991 25.4929C27.5062 25.4929 28.3246 24.6737 28.3246 23.6691C28.3246 22.6645 27.5062 21.8453 26.4991 21.8453Z" fill="#001344" />
                        <path d="M32.504 21.8453C31.4985 21.8453 30.6802 22.6645 30.6802 23.6691C30.6802 24.6737 31.4994 25.4929 32.504 25.4929C33.5103 25.4929 34.3295 24.6737 34.3295 23.6691C34.3295 22.6645 33.5103 21.8453 32.504 21.8453Z" fill="#001344" />
                    </svg>
                    <span class="title"><?php esc_html_e('Need some help?', 'solace-extra'); ?></span>
                    <span class="desc"><?php esc_html_e('We would love to be of any assistance.', 'solace-extra'); ?></span>
                    <a href="https://wordpress.org/support/plugin/solace-extra/"><?php esc_html_e('Open Ticket', 'solace-extra'); ?></a>
                </div>
                <div class="col2">
                    <svg width="58" height="58" viewBox="0 0 58 58" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22.4158 19.9888C17.7549 19.0298 13.0285 19.0298 8.36771 19.9888C7.73239 20.1195 7.32329 20.7406 7.45402 21.3761C7.66897 22.4212 8.69953 22.319 8.8413 22.2898C13.1878 21.3953 17.5957 21.3953 21.9424 22.2898C22.5779 22.4205 23.1989 22.0113 23.3296 21.3761C23.4603 20.7406 23.0512 20.1196 22.4158 19.9888Z" fill="#001644" />
                        <path d="M22.4158 25.3136C17.7549 24.3545 13.0286 24.3545 8.36771 25.3136C7.73239 25.4443 7.32329 26.0654 7.45402 26.7009C7.58475 27.3362 8.20527 27.7449 8.8413 27.6146C13.1878 26.7201 17.5958 26.7201 21.9424 27.6146C22.0347 27.6336 23.1134 27.752 23.3296 26.7009C23.4603 26.0654 23.0512 25.4443 22.4158 25.3136Z" fill="#001644" />
                        <path d="M22.4158 14.6642C17.7549 13.7051 13.0285 13.7051 8.36771 14.6642C7.73239 14.7949 7.32329 15.416 7.45402 16.0514C7.66897 17.0966 8.69953 16.9944 8.8413 16.9651C13.1878 16.0707 17.5957 16.0707 21.9424 16.9651C22.5779 17.0955 23.1989 16.6866 23.3296 16.0514C23.4603 15.416 23.0512 14.7949 22.4158 14.6642Z" fill="#001644" />
                        <path d="M22.4158 9.33939C17.7549 8.38036 13.0286 8.38036 8.36771 9.33939C7.73239 9.47013 7.32329 10.0912 7.45402 10.7267C7.58475 11.362 8.20527 11.7707 8.8413 11.6404C13.1878 10.7459 17.5958 10.7459 21.9424 11.6404C22.0347 11.6594 23.1134 11.7778 23.3296 10.7267C23.4603 10.0912 23.0512 9.47013 22.4158 9.33939Z" fill="#001644" />
                        <path d="M38.6037 24.8613L48.5764 20.5613C49.5639 20.1355 50.1774 19.203 50.1774 18.1277C50.1774 17.0524 49.5639 16.1199 48.5764 15.6942L38.6037 11.3941C37.7822 11.0397 36.8454 11.122 36.098 11.6137C35.3505 12.1053 34.9043 12.933 34.9043 13.8277V22.4279C34.9043 23.3225 35.3505 24.1502 36.098 24.6419C36.8423 25.1315 37.7813 25.2159 38.6037 24.8613ZM37.389 22.6793C37.3272 22.6387 37.2534 22.562 37.2534 22.4279V13.8277C37.2534 13.6936 37.3272 13.617 37.389 13.5762C37.4517 13.5349 37.5474 13.497 37.6737 13.5513L47.6465 17.8514C47.7967 17.9161 47.8282 18.0373 47.8282 18.1278C47.8282 18.2182 47.7967 18.3394 47.6465 18.4043L37.6737 22.7044C37.5504 22.7572 37.4507 22.72 37.389 22.6793Z" fill="#001644" />
                        <path d="M57.3113 50.9783L54.6449 38.8929C54.2676 37.1838 52.7653 36.0858 51.0751 36.2818L43.7093 37.1358L43.1177 34.4539C46.8245 34.4861 50.5289 34.8329 54.2101 35.4956C56.0124 35.8201 57.2901 34.5324 57.2901 33.3035V3.81183C57.2901 2.74744 56.4651 1.84749 55.2837 1.62315C46.5523 -0.0345151 37.6995 0.0217464 28.9663 1.78723C20.2332 0.021629 11.3804 -0.0343977 2.64908 1.62303C1.46771 1.84737 0.642578 2.74732 0.642578 3.81171V33.3035C0.642578 34.4867 1.86307 35.8304 3.72275 35.4956C12.0192 34.0017 20.4328 34.1102 28.7297 35.8175C28.886 35.8486 29.0468 35.8486 29.2031 35.8175C31.8736 35.2679 34.5563 34.885 37.2433 34.6669L37.9935 38.0673H9.11153C4.4417 38.0673 0.642578 41.8664 0.642578 46.5362C0.642578 51.206 4.4417 55.0052 9.11153 55.0052H41.7303L41.875 55.6613C42.2198 57.2227 43.8455 57.1295 44.1806 57.0231L56.0268 53.2579C56.9632 52.9603 57.5276 51.9591 57.3113 50.9783ZM54.941 51.1383L44.0468 54.6008L43.7922 53.4468L54.6863 49.9843L54.941 51.1383ZM38.727 30.4887C38.6469 30.1259 38.8666 29.7154 39.1973 29.6103C39.5086 29.5113 39.6741 29.7485 39.7185 29.9506L41.644 38.6778C41.7739 39.2663 42.3283 39.6611 42.9263 39.5915L51.3458 38.6152C51.8231 38.5596 52.237 38.8821 52.3511 39.399L54.1783 47.6806L42.5621 51.3725L35.247 47.0084C35.2467 46.9917 35.2503 46.9661 35.2673 46.9358C35.4419 46.624 35.7186 46.398 36.0258 46.3159C36.1928 46.2711 36.445 46.2493 36.6969 46.3994L40.743 48.8112C41.1454 49.0512 41.652 49.029 42.0318 48.7547C42.4117 48.4805 42.5923 48.0068 42.4913 47.5492L38.727 30.4887ZM3.30649 33.1837C3.16953 33.2082 3.05771 33.1826 2.9917 33.1549V3.95912C3.0159 3.9489 3.04761 3.93856 3.0872 3.93105C11.282 2.37534 19.5885 2.38215 27.7918 3.94937V33.2414C16.7004 31.1958 7.81329 32.3759 3.30649 33.1837ZM30.1409 33.2414V3.94937C38.3443 2.38227 46.6508 2.37545 54.8455 3.93105C54.8851 3.93856 54.9168 3.9489 54.9409 3.95912V33.1549C54.875 33.1827 54.7635 33.2084 54.6261 33.1837C50.6348 32.4651 46.6177 32.1053 42.5988 32.1022L42.0125 29.4444C41.8392 28.6592 41.3542 27.9867 40.6819 27.5992C40.0145 27.2145 39.2344 27.1336 38.4856 27.3716C36.9911 27.8466 36.0895 29.4381 36.4329 30.9949L36.7324 32.3522C34.531 32.5414 32.3324 32.8372 30.1409 33.2414ZM2.9917 46.5363C2.9917 43.1619 5.73713 40.4165 9.11153 40.4165H38.5117L39.6027 45.3618H39.5435L37.8993 44.3816C37.1536 43.9374 36.2728 43.8184 35.4187 44.0465C34.6613 44.249 33.9823 44.7183 33.4968 45.3616H18.104C17.571 43.712 16.0211 42.5151 14.1963 42.5151C12.3715 42.5151 10.8217 43.712 10.2887 45.3616H6.98933C6.34062 45.3616 5.81477 45.8876 5.81477 46.5362C5.81477 47.1848 6.34062 47.7108 6.98933 47.7108H10.2383C10.717 49.4475 12.3096 50.7272 14.1964 50.7272C16.0833 50.7272 17.6759 49.4475 18.1546 47.7108H33.0084C33.1689 48.2391 33.507 48.706 34.0003 49.0002L40.1281 52.656H9.11153C5.73701 52.656 2.9917 49.9107 2.9917 46.5363ZM15.9532 46.6212C15.9532 47.59 15.1651 48.3782 14.1963 48.3782C13.2276 48.3782 12.4394 47.59 12.4394 46.6212C12.4394 45.6525 13.2276 44.8643 14.1963 44.8643C15.1651 44.8643 15.9532 45.6525 15.9532 46.6212Z" fill="#001644" />
                    </svg>
                    <span class="title"><?php esc_html_e('Documentation', 'solace-extra'); ?></span>
                    <span class="desc"><?php esc_html_e('Learn about any aspect of Solace Theme.', 'solace-extra'); ?></span>
                    <a href="https://solacewp.com/documentation"><?php esc_html_e('Start reading', 'solace-extra'); ?></a>
                </div>
                <div class="col3">
                    <svg width="46" height="47" viewBox="0 0 46 47" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M45.1749 4.16261C45.0769 2.36604 43.6481 0.937386 41.8515 0.839334C38.2264 0.641285 31.1327 0.833945 24.3496 4.34237C20.8917 6.131 17.2346 9.16347 14.3161 12.6623C14.2801 12.7054 14.2451 12.7488 14.2094 12.792L7.58603 13.3036C6.49579 13.3879 5.52471 13.9593 4.92173 14.8713L0.40301 21.706C-0.0543044 22.3977 -0.127005 23.2633 0.208406 24.0214C0.543905 24.7797 1.23328 25.3081 2.05259 25.4351L7.63284 26.2994C7.61315 26.4078 7.59336 26.5162 7.57525 26.6247C7.38948 27.736 7.75766 28.8785 8.56028 29.681L16.3331 37.454C16.9985 38.1194 17.8977 38.4862 18.8191 38.4862C19.0088 38.4862 19.1996 38.4706 19.3895 38.4389C19.498 38.4208 19.6064 38.401 19.7149 38.3813L20.5791 43.9616C20.7061 44.781 21.2345 45.4704 21.9926 45.8058C22.3081 45.9454 22.6419 46.0143 22.9742 46.0143C23.4409 46.0142 23.9043 45.8784 24.3081 45.6113L31.1429 41.0925C32.0549 40.4894 32.6263 39.5184 32.7104 38.4282L33.222 31.8049C33.2652 31.7692 33.3087 31.7342 33.3518 31.6983C36.8507 28.7797 39.8832 25.1226 41.6718 21.6646C45.1804 14.8813 45.3727 7.78747 45.1749 4.16261ZM29.6813 38.8818L23.1435 43.2043L22.3012 37.7659C25.0643 36.9535 27.7977 35.6523 30.4017 33.9092L30.0684 38.224C30.0477 38.4931 29.9065 38.733 29.6813 38.8818ZM18.207 35.5801L10.4341 27.8072C10.2357 27.6088 10.1441 27.3301 10.189 27.0616C10.4201 25.6798 10.7792 24.3644 11.2237 23.1252L22.8865 34.788C21.3982 35.3211 20.0651 35.6391 18.9525 35.8251C18.6836 35.8698 18.4053 35.7784 18.207 35.5801ZM7.79017 15.9458L12.1048 15.6125C10.3616 18.2166 9.06044 20.9499 8.24802 23.7131L2.80972 22.8708L7.13234 16.3329C7.28127 16.1076 7.5211 15.9666 7.79017 15.9458ZM31.6545 29.6631C29.5139 31.4486 27.4359 32.7401 25.5206 33.6746L12.3391 20.4931C13.5633 17.9928 15.0573 15.9108 16.351 14.3598C19.0519 11.1219 22.4111 8.32861 25.5672 6.69617C31.7926 3.47607 38.3516 3.30266 41.7073 3.48534C42.1514 3.50955 42.5047 3.8628 42.5289 4.30704C42.7118 7.66274 42.5381 14.2217 39.318 20.4471C37.6856 23.6032 34.8924 26.9622 31.6545 29.6631Z" fill="#001B44" />
                        <path d="M30.9814 21.6549C32.6776 21.6548 34.3746 21.009 35.666 19.7177C36.9173 18.4664 37.6064 16.8027 37.6064 15.0331C37.6064 13.2636 36.9173 11.5999 35.666 10.3486C33.0828 7.76539 28.8799 7.76556 26.2969 10.3486C25.0455 11.5999 24.3564 13.2636 24.3564 15.0331C24.3564 16.8027 25.0456 18.4664 26.2969 19.7177C27.5885 21.0093 29.2846 21.6551 30.9814 21.6549ZM28.1706 12.2224C28.9455 11.4474 29.9633 11.06 30.9813 11.06C31.9992 11.06 33.0172 11.4474 33.7921 12.2224C34.5428 12.9731 34.9562 13.9713 34.9562 15.033C34.9562 16.0947 34.5428 17.093 33.7921 17.8438C32.2423 19.3936 29.7204 19.3935 28.1705 17.8438C27.4198 17.093 27.0062 16.0948 27.0062 15.0331C27.0062 13.9714 27.4198 12.9731 28.1706 12.2224Z" fill="#001B44" />
                        <path d="M1.35136 38.0585C1.69048 38.0585 2.0296 37.9291 2.28825 37.6703L6.61431 33.3443C7.13178 32.8268 7.13178 31.9879 6.61431 31.4704C6.09693 30.9529 5.25792 30.9529 4.74045 31.4704L0.41447 35.7965C-0.103 36.3139 -0.103 37.1528 0.41447 37.6703C0.673117 37.929 1.01224 38.0585 1.35136 38.0585Z" fill="#001B44" />
                        <path d="M10.5791 35.4349C10.0617 34.9174 9.22273 34.9174 8.70526 35.4349L0.388103 43.7521C-0.129368 44.2696 -0.129368 45.1086 0.388103 45.626C0.646838 45.8847 0.985871 46.0141 1.32499 46.0141C1.66411 46.0141 2.00323 45.8847 2.26188 45.6259L10.579 37.3087C11.0966 36.7913 11.0966 35.9524 10.5791 35.4349Z" fill="#001B44" />
                        <path d="M12.6697 39.3996L8.34367 43.7256C7.8262 44.2431 7.8262 45.082 8.34367 45.5995C8.60241 45.8583 8.94152 45.9876 9.28055 45.9876C9.61959 45.9876 9.9588 45.8583 10.2174 45.5995L14.5435 41.2734C15.061 40.756 15.061 39.9171 14.5435 39.3996C14.0261 38.8821 13.1871 38.8821 12.6697 39.3996Z" fill="#001B44" />
                    </svg>
                    <span class="title"><?php esc_html_e('GO PRO', 'solace-extra'); ?></span>
                    <span class="desc"><?php esc_html_e('Full access to premium features.', 'solace-extra'); ?></span>
                    <a class="disabled" style="opacity: 0.5;"><?php esc_html_e('Upgrade', 'solace-extra'); ?></a>
                </div>
                <div class="col4">
                    <svg width="49" height="56" viewBox="0 0 49 56" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.640625 15.1582V39.9351C0.643744 42.4678 2.69622 44.5203 5.22897 44.5234H14.4055C14.6939 44.5257 14.965 44.6612 15.1397 44.8904L22.3819 54.5443C22.9112 55.1787 23.697 55.5424 24.5232 55.5353C25.3494 55.5282 26.129 55.151 26.6472 54.5075L33.86 44.8904C34.0351 44.6615 34.306 44.5261 34.5942 44.5234H43.7707C46.3035 44.5204 48.356 42.4678 48.3591 39.9351V15.1582C48.356 12.6255 46.3035 10.573 43.7707 10.5699H37.7583C36.0494 4.36544 30.2642 0.177252 23.8363 0.491264C17.9038 0.789146 12.8268 4.8484 11.2305 10.5699H5.22897C2.69622 10.573 0.643744 12.6255 0.640625 15.1582ZM23.9227 2.32469C27.1829 2.16682 30.3655 3.35168 32.7288 5.60321C35.0921 7.85485 36.4295 10.9765 36.4294 14.2406C36.442 17.5406 35.071 20.6949 32.6497 22.9372C30.338 25.1676 29.0494 28.2531 29.0882 31.465V32.5937H19.9115V31.6192C19.9515 28.3375 18.646 25.1825 16.2988 22.8886C12.8276 19.6054 11.6527 14.5665 13.3136 10.0867C14.9745 5.60676 19.1501 2.5517 23.9227 2.32469ZM27.2528 39.0174H21.7469C20.7332 39.0174 19.9115 38.1957 19.9115 37.1821V34.4291H29.0882V37.1821C29.0882 38.1957 28.2665 39.0174 27.2528 39.0174ZM2.47598 15.1582C2.47598 13.6378 3.70859 12.4052 5.22897 12.4052H10.8698C10.8441 12.597 10.8084 12.786 10.7918 12.9806C10.4006 17.1817 11.967 21.3286 15.0379 24.222C17.0191 26.1689 18.1169 28.8418 18.0763 31.6192V37.1821C18.0825 38.8508 19.2135 40.3052 20.8292 40.7225V41.7704C20.8292 42.2773 21.24 42.688 21.7469 42.688C22.2537 42.688 22.6645 42.2773 22.6645 41.7704V40.8527H26.3352V41.7704C26.3352 42.2773 26.746 42.688 27.2528 42.688C27.7597 42.688 28.1705 42.2773 28.1705 41.7704V40.7225C29.7862 40.3052 30.9172 38.8508 30.9234 37.1821V31.465C30.8834 28.7611 31.9616 26.1605 33.9031 24.2779C36.6976 21.69 38.2796 18.0493 38.2648 14.2406C38.2602 13.6264 38.2151 13.0134 38.1299 12.4052H43.7707C45.2911 12.4052 46.5237 13.6378 46.5237 15.1582V39.9351C46.5237 41.4554 45.2911 42.688 43.7707 42.688H34.5942C33.7286 42.6922 32.9144 43.0993 32.3918 43.7892L25.2083 53.3706C24.8349 53.7631 24.2143 53.7795 23.8207 53.4073L16.6079 43.7892C16.0856 43.099 15.2712 42.6918 14.4055 42.688H5.22897C3.70859 42.688 2.47598 41.4554 2.47598 39.9351V15.1582Z" fill="#011B44" />
                        <path d="M22.6647 26.1701C22.1579 26.1701 21.7471 26.5809 21.7471 27.0877V29.8407C21.7471 30.3475 22.1579 30.7585 22.6647 30.7585C23.1715 30.7585 23.5823 30.3475 23.5823 29.8407V27.0877C23.5823 26.5809 23.1715 26.1701 22.6647 26.1701Z" fill="#011B44" />
                        <path d="M21.7471 22.4995C21.7471 23.0064 22.158 23.4171 22.6647 23.4171C23.1715 23.4171 23.5824 23.0064 23.5824 22.4995V21.5819C23.5824 21.0751 23.1715 20.6642 22.6647 20.6642C22.158 20.6642 21.7471 21.0751 21.7471 21.5819V22.4995Z" fill="#011B44" />
                        <path d="M26.3351 30.7585C26.8419 30.7585 27.2527 30.3476 27.2527 29.8409V27.0878C27.2527 26.5811 26.8419 26.17 26.3351 26.17C25.8283 26.17 25.4175 26.5811 25.4175 27.0878V29.8409C25.4175 30.3476 25.8283 30.7585 26.3351 30.7585Z" fill="#011B44" />
                        <path d="M26.3351 23.4172C26.8419 23.4172 27.2527 23.0064 27.2527 22.4995V21.5818C27.2527 21.075 26.8419 20.6642 26.3351 20.6642C25.8283 20.6642 25.4175 21.075 25.4175 21.5818V22.4995C25.4175 23.0064 25.8283 23.4172 26.3351 23.4172Z" fill="#011B44" />
                        <path d="M9.81732 6.89923C10.2072 6.89945 10.5546 6.65329 10.6837 6.2854C10.8127 5.91762 10.6954 5.50833 10.3908 5.26486L5.80259 1.59425C5.40674 1.27745 4.82904 1.34154 4.51234 1.73739C4.19554 2.13324 4.25963 2.71083 4.65548 3.02763L9.24382 6.69824C9.40664 6.82847 9.60892 6.89934 9.81732 6.89923Z" fill="#011B44" />
                        <path d="M39.7562 6.69824L44.3445 3.02763C44.7402 2.71083 44.8043 2.13324 44.4876 1.73739C44.1708 1.34154 43.5933 1.27745 43.1974 1.59425L38.6091 5.26486C38.353 5.46972 38.2258 5.79567 38.2751 6.1199C38.3246 6.44413 38.5433 6.71728 38.8487 6.83665C39.1542 6.95591 39.5001 6.90311 39.7562 6.69824Z" fill="#011B44" />
                        <path d="M4.51237 33.1673C4.66443 33.3574 4.88585 33.4794 5.12781 33.5061C5.36977 33.533 5.6126 33.4626 5.80261 33.3104L10.391 29.6398C10.7867 29.323 10.8508 28.7454 10.5341 28.3496C10.2173 27.9537 9.63969 27.8896 9.24384 28.2065L4.6555 31.877C4.46537 32.0291 4.34343 32.2506 4.31665 32.4925C4.28976 32.7345 4.3602 32.9773 4.51237 33.1673Z" fill="#011B44" />
                        <path d="M43.1973 33.3104C43.5932 33.6273 44.1708 33.5631 44.4876 33.1673C44.8043 32.7715 44.7402 32.1938 44.3445 31.877L39.7561 28.2065C39.3603 27.8896 38.7827 27.9537 38.4659 28.3496C38.1492 28.7454 38.2133 29.323 38.609 29.6398L43.1973 33.3104Z" fill="#011B44" />
                        <path d="M16.0658 12.3878C16.1235 12.3993 16.1823 12.4052 16.2411 12.4052C16.68 12.4044 17.057 12.0929 17.1404 11.6619C17.7983 8.28218 21.145 6.84331 21.1781 6.82955C21.6466 6.6362 21.8697 6.09958 21.6764 5.63103C21.483 5.16249 20.9464 4.93945 20.4779 5.1327C20.3026 5.20432 16.1869 6.94418 15.339 11.3131C15.2431 11.8106 15.5684 12.2915 16.0658 12.3878Z" fill="#011B44" />
                        <path d="M5.22915 16.9936H7.98214C8.48896 16.9936 8.89976 16.5828 8.89976 16.0759C8.89976 15.5691 8.48896 15.1582 7.98214 15.1582H5.22915C4.72232 15.1582 4.31152 15.5691 4.31152 16.0759C4.31152 16.5828 4.72232 16.9936 5.22915 16.9936Z" fill="#011B44" />
                        <path d="M41.0177 16.9936H43.7707C44.2776 16.9936 44.6883 16.5828 44.6883 16.0759C44.6883 15.5691 44.2776 15.1582 43.7707 15.1582H41.0177C40.5109 15.1582 40.1001 15.5691 40.1001 16.0759C40.1001 16.5828 40.5109 16.9936 41.0177 16.9936Z" fill="#011B44" />
                    </svg>
                    <span class="title"><?php esc_html_e('Suggestions', 'solace-extra'); ?></span>
                    <span class="desc"><?php esc_html_e('Let us know how we can improve.', 'solace-extra'); ?></span>
                    <a href="https://solacewp.com/suggestions"><?php esc_html_e('Contact Us', 'solace-extra'); ?></a>
                </div>
            </div>
        </div>
    </section>
    <footer class="bottom">
        <div class="mycontainer">
            <div class="box left">
                <a href="<?php echo esc_url($myadmin . '/wp-admin'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512">
                        <path d="M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.2 288 416 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-306.7 0L214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z" />
                    </svg>
                    <span><?php esc_html_e('Back', 'solace-extra'); ?></span>
                </a>
            </div>

            <div class="box center">
                <a href="<?php echo esc_url($myadmin . '/wp-admin'); ?>">
                    <span><?php esc_html_e('Back to WordPress Dashboard', 'solace-extra'); ?></span>
                </a>
            </div>                 

            <div class="box right">
                <a href="<?php echo esc_url($myadmin . '/wp-admin/admin.php?page=dashboard-video'); ?>">
                    <span><?php esc_html_e('Next', 'solace-extra'); ?></span>
                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><path d="M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"/></svg>
                </a>
            </div>
        </div>
    </footer>
</div>
